import Utilities.gui_creator as gc
import Utilities.nidaq_operations as no

root = gc.create_window(title='DC Voltmeter',
                        size='250x100')

channel_name = 'Dev1/ai0'
task = no.create_ai_task(channel_name)

lbl_2 = gc.create_indicator(root,
                            label_1='Voltage Reading (V)')

def acquire_sample():
    
    float_data = task.read()
#    string_data = str(float_data)
    string_data = f'{float_data:.4f}'

    lbl_2.config(text=string_data)

    return

btn = gc.action_button(root, label='Read Sample',
                       action=acquire_sample)

root.mainloop()

task.close()
